<?php
/*
Plugin Name: Custom News Articles
Description: Adds a custom post type for news articles organized by topics and provides a way to view them.
Version: 1.0
Author: Your Name
*/

// Register Custom Post Type
function custom_news_post_type() {

    $labels = array(
        'name'                  => _x('News Articles', 'Post Type General Name', 'text_domain'),
        'singular_name'         => _x('News Article', 'Post Type Singular Name', 'text_domain'),
        'menu_name'             => __('News', 'text_domain'),
        'name_admin_bar'        => __('News Article', 'text_domain'),
        'archives'              => __('Article Archives', 'text_domain'),
        'attributes'            => __('Article Attributes', 'text_domain'),
        'parent_item_colon'     => __('Parent Article:', 'text_domain'),
        'all_items'             => __('All Articles', 'text_domain'),
        'add_new_item'          => __('Add New Article', 'text_domain'),
        'add_new'               => __('Add New', 'text_domain'),
        'new_item'              => __('New Article', 'text_domain'),
        'edit_item'             => __('Edit Article', 'text_domain'),
        'update_item'           => __('Update Article', 'text_domain'),
        'view_item'             => __('View Article', 'text_domain'),
        'view_items'            => __('View Articles', 'text_domain'),
        'search_items'          => __('Search Article', 'text_domain'),
        'not_found'             => __('Not found', 'text_domain'),
        'not_found_in_trash'    => __('Not found in Trash', 'text_domain'),
        'featured_image'        => __('Featured Image', 'text_domain'),
        'set_featured_image'    => __('Set featured image', 'text_domain'),
        'remove_featured_image' => __('Remove featured image', 'text_domain'),
        'use_featured_image'    => __('Use as featured image', 'text_domain'),
        'insert_into_item'      => __('Insert into article', 'text_domain'),
        'uploaded_to_this_item' => __('Uploaded to this article', 'text_domain'),
        'items_list'            => __('Articles list', 'text_domain'),
        'items_list_navigation' => __('Articles list navigation', 'text_domain'),
        'filter_items_list'     => __('Filter articles list', 'text_domain'),
    );

    $args = array(
        'label'                 => __('News Article', 'text_domain'),
        'description'           => __('Custom post type for news articles', 'text_domain'),
        'labels'                => $labels,
        'supports'              => array('title', 'editor', 'thumbnail', 'excerpt', 'custom-fields'),
        'taxonomies'            => array('topic'),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-welcome-widgets-menus',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'post',
    );

    register_post_type('news_article', $args);
}

add_action('init', 'custom_news_post_type', 0);

// Register Custom Taxonomy
function custom_news_taxonomy() {

    $labels = array(
        'name'                       => _x('Topics', 'Taxonomy General Name', 'text_domain'),
        'singular_name'              => _x('Topic', 'Taxonomy Singular Name', 'text_domain'),
        'menu_name'                  => __('Topics', 'text_domain'),
        'all_items'                  => __('All Topics', 'text_domain'),
        'parent_item'                => __('Parent Topic', 'text_domain'),
        'parent_item_colon'          => __('Parent Topic:', 'text_domain'),
        'new_item_name'              => __('New Topic Name', 'text_domain'),
        'add_new_item'               => __('Add New Topic', 'text_domain'),
        'edit_item'                  => __('Edit Topic', 'text_domain'),
        'update_item'                => __('Update Topic', 'text_domain'),
        'view_item'                  => __('View Topic', 'text_domain'),
        'separate_items_with_commas' => __('Separate topics with commas', 'text_domain'),
        'add_or_remove_items'        => __('Add or remove topics', 'text_domain'),
        'choose_from_most_used'      => __('Choose from the most used topics', 'text_domain'),
        'popular_items'              => __('Popular Topics', 'text_domain'),
        'search_items'               => __('Search Topics', 'text_domain'),
        'not_found'                  => __('Not Found', 'text_domain'),
        'no_terms'                   => __('No topics', 'text_domain'),
        'items_list'                 => __('Topics list', 'text_domain'),
        'items_list_navigation'      => __('Topics list navigation', 'text_domain'),
    );

    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
    );

    register_taxonomy('topic', array('news_article'), $args);
}
add_action('init', 'custom_news_taxonomy', 0);

// Custom Template for News Articles
function custom_news_template($template) {
    if (is_singular('news_article')) {
        $new_template = locate_template(array('single-news_article.php'));
        if ('' != $new_template) {
            return $new_template;
        }
    }
    return $template;
}
add_filter('template_include', 'custom_news_template');

// Flush Rewrite Rules on Activation
function custom_news_flush_rewrite_rules() {
    custom_news_post_type();
    flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'custom_news_flush_rewrite_rules');
